<?php

# fmt trims left zeros
function fmt( $text ){
	for( $i = 0; substr( $text, $i, 1 ) == "0"; $i++ ) ;
	return substr( $text, $i );
}

# par left fills string with leading zeros to length $l and appends "#"
function par( $str, $l ){
	for( $i = strlen($str); $i < $l; $i++ ) $str = "0".$str;
	return $str."#";
}

# fill left fills string with leading zeros to length $l
function fill( $str, $l ){
	for( $i = strlen($str); $i < $l; $i++ ) $str = "0".$str;
	return $str;
}

# mlst creates the mailinglist address for given proj_id and titlabb
function mlst( $ta ){
	global $maildom;
	return "\"Projekt $ta\" <".strtolower( $ta )."@$maildom>";
}

# date_de convert YYYY/MM/DD to DD.MM.YYYY
function date_de( $d ){
	return( substr( $d, 8, 2 ).".".substr( $d, 5, 2 ).".".substr( $d, 0, 4 ));
}

# time_de extracts HH:MM from datetime string
function time_de( $d ){
	return( substr( $d, 11, 5 ));
}

# dt_dt combines date_de and time_de
function dt_de( $d ){
	return date_de( $d ).", ".time_de( $d );
}

# st_lg translates status - into given language
function st_lg( $st ){
	global $_ini, $_arc, $_act, $_fin;
	switch( $st ){
		case "ini": $st = $_ini; break;
		case "arc": $st = $_arc; break;
		case "act": $st = $_act; break;
		case "fin": $st = $_fin; break;
	}
	return $st;
}

# in_arr simulates in_array of PHP4 for PHP3: is value in array?
function in_arr( $val, $arr ){
	if( !is_array( $arr )) return( FALSE );
	reset( $arr );
	while( list( , $v ) = each( $arr )){
		if( $v == $val ) return( TRUE );
	}
	return( FALSE );
}

# returns RGB-color code for a given percent value
function get_col( $colorlist, $percent  ){
	$colarr = explode( '*', $colorlist );
	$n = count( $colarr );		# n values in color array
	$f = 100 / $n;			# means n steps in percent scale
	$i = 0;
	while(( $i < $n ) && ( $percent >= ( $i * $f ))) $i++;
	return( $colarr[ $i-1 ]);
}

# checks if mid is maintainer
function is_maintainer( $mid ){
	global $_admin;
	$m = explode( '#', $_admin );
	$m_no = count( $m );
	for( $i = 0; $i < $m_no && $m[$i] != $mid; $i++ );
	return( $i < $m_no );
}

# returns pj-type text
function pj_type( $pjtype ){
	global $_rubr, $_lnk, $_proj;
	switch( $pjtype ){
		case 0: $rbs = ucfirst( $_rubr );
		break;
		case 1: $rbs = ucfirst( $_lnk );
		break;
		default: $rbs = ucfirst( $_proj );
	}
	return( $rbs );
}

# inserts newlines at word ends at the nearest blank 
# from string part of length $l; $c means comment with "> " or not
function insert_nl( $str, $l, $c ){
	$str = eregi_replace( '<br>', "\n", $str );
	$k = 0;
	$s = '';
	if( $c ) $l -= 2;
	while( !empty( $str ) && ( $k++ < 1000 )){
		$i = $l;
		if( strlen( $str ) > $l ){
			$i = strpos( $str, "\n" );	# test existing newlines
			if(( $i > $l ) || ( $i == 0 )){
				$i = $l;
				while(( $i > 0 ) && ( substr( $str, $i, 1 ) <> ' ')) $i--;
			}
			if( $i == 0 ){
				$i = $l;
				while(( $i < ( $l*3 )) && ( substr( $str, $i, 1 ) <> ' ')) $i++;
			}
		}	
		if( $i == 0 ) $i = $l + 1;
		if( $c ) $s .= '> ';
		$s .= substr( $str, 0, $i )."\n";
		$str = substr( $str, ++$i );
	}
	return $s;
}

?>