<?php
require( "const.inc" );

# errlog write error msg to file
# flag: 1 = show err msg; 2 = use mysql errno; 4 = immediate exit
# errno: error numbers are grouped by script:
# index.phtml (main)	00001-00020
# - tabl.inc		00021-00050
# - menu.inc		00051-00099
# member.phtml		01001-01099
# - memb.inc		01001-01050
# - mins.inc		01051-01070
# - mnum.inc		01071-01099
# maintainer.phtml	02001-02099
# - maint.inc		02001-02099
# modify.phtml		03001-03010
# - modi.inc		03011-03099
# setup*.phtml		04001-04099
# - setupform.phtml	04001-04010
# - setupres.phtml	04011-04099
# finished.phtml	05001-05099
# comments.phtml	06001-06099
# browse.phtml		08001-08010
# - s_short.inc		08011-08020
# - s_hiera.inc		08021-08040
# - s_catch.inc		08041-08060
# index.phtml (proj)	20001-20099
# - indx.inc		20001-20099
# text.phtml (proj)	21001-21099
# - view.inc		21001-21099
# calc.phtml		30001-30099
function errlog( $msg, $errno, $flag ){
	global $PHP_SELF;
	$logfile = "../otlog/weberr.log";
	$msg = date( "d.m.Y H:i:s" )." - $PHP_SELF: $msg";
	if( $errno > 0 ) $msg .= " ErrNo. $errno-";
	if( $flag & 2 ) $msg .= mysql_errno().": ".mysql_error();
	$msg .= "\n";
	if( $fp = fopen( $logfile, "a", 1 )){
		fputs( $fp, $msg );
		fclose( $fp );
	}
	if( $flag & 1 ){
		if( $errno ) echo "<font color='red'>Oops, an error occured:</font>";
		echo "<br>$msg";
	}
	if( $flag & 4 ) exit;
}

# validate email address
function check_email( $e ){
return(ereg("^[-!#$%&\'*+\\./0-9=?A-Z^_'a-z{|}~]+".'@'."[-!#$%&\'*+\\/0-9=?A-Z^_'a-z{|}~]+\."."[-!#$%&\'*+\\./0-9=?A-Z^_'a-z{|}~]+$",$e));
}

function lnkxid( $lnk, $xid ){
	global $lang, $langs;
	if( !empty( $xid )){
		$lnk .= strchr( $lnk, '?' ) ? "&xid=$xid" : "?xid=$xid";
		if( !empty( $lang )) $lnk .= "&lang=$lang";
	} elseif( !empty( $lang )){
		reset( $langs );
		if( key( $langs ) != $lang ){
			$lnk .= strchr( $lnk, '?' ) ? "&lang=$lang" : "?lang=$lang";
		}
	}
	return( $lnk );
}


# adds xid (session id) to all links in text
function add_xid( $txt, $xid ){
	global $fqdomain;
#	if( empty( $xid )) return( $txt );
	$patt = "/<a\s*href\s*=\s*[\"']?([^>]+)[\"']?[^>]*>/i";
	if( $n = preg_match_all( $patt, $txt, $out, PREG_SET_ORDER )){
		for( $i = 0; $i < $n; $i++ ){
			$t1 = $out[$i][0];
			$t2 = $out[$i][1];
			$tt = '';
			$a = strrpos( $t2, '#' );
			if( $a ) {
				$tt = substr( $t2, $a - strlen( $t2 ));
				$t2 = substr( $t2, 0, $a );
			}
			$t2 = str_replace( '\"', '', $t2 );
			$t2 = str_replace( "\'", '', $t2 );
			$t2 = str_replace( '"', '', $t2 );
			$t2 = str_replace( "'", '', $t2 );
			$b1 = strpos( $t2, $fqdomain );		# has fqdomain
			$b2 = substr( $t2, 0, 1 ) == '/';	# starts with /
			$b3 = strpos( $t2, '.phtml' );		# has .phtml
			$b4 = strpos( $t2, 'ttp://' );		# has ttp://
			if( $b1 || $b2 || ( !$b4 && $b3 )) {
				$t3 = $t2;
				if( !$b3 && !strpos( $t3, '?' ) && substr( $t3, -1 ) != '/' ) $t3 .= '/';
				$t2 = str_replace( $t2, lnkxid( $t3, $xid ).$tt, $t1 );
				$txt = str_replace( $t1, $t2, $txt );
			}
		}
	}
	return( $txt );
}

function upd_global( $col, $val ){
	$qry = "update global set $col = $val where $col < $val";
	if( !mysql_query( $qry )) errlog( $qry, 51, 7 );
}

function get_global( $col ){
	$qry = "select $col from global";
	if( !$id = mysql_query( $qry )) errlog( $qry, 52, 7 );
	if( $row = mysql_fetch_row( $id )) return( $row[ 0 ]);
	return( 0 );
}

function upd_points( $pj, $ver, $pts, $key, $val ){
	if( $ver > 0 ){
		$l = "and vers_id = $ver";
	}
	else {
		$l = "and status = 'act'";
	}
	$qry .= "select actrate from metatext where titlabb = '$pj' $l";
	if( !$id = mysql_query( $qry )) errlog( $qry, 53, 7 );
	if( !$row = mysql_fetch_array( $id )) errlog( 'no rows selected', 54, 5 );
	# calcute points from maxpoints ($pts) and actrate
	$tt = $pts * $row[ 'actrate' ] / 100;
	$t = $key != 'clic' ? $val * 10 : $val;
	# increase/decrease points ($val or $t resp. can be negative)
	$tt += $t;
	if( $tt < 0 ){
		$tt = 0;
	}
	elseif( $tt > $pts ){
		$pts = $tt;
	}
	$t = $tt * 100 / $pts;
	$key .= 'num';
	$qry = "update metatext set $key = $key + $val, actrate = $t ";
	$qry .= "where titlabb = '$pj' $l";
	if( !mysql_query( $qry )) errlog( $qry, 55, 7 );
	if( $tt == $pts ) upd_global( 'pjpts', $tt );
}

function menu( $fn_memb, $is_maint ) {
	global $xid, $_fontmenu, $_lk1, $_lk2, $_memb, $_maint, $_ismemb, $_ismaint;
	echo "<font $_fontmenu>\n";
	while( list( $k, $t ) = each( $_lk1 )){
		echo add_xid( $t, $xid );
		echo "&nbsp;&nbsp;\n";
	}
	$t = $_memb;
	if( !empty( $fn_memb )) $t = "$fn_memb $_ismemb";
	echo "<a href='".lnkxid( '/member.phtml', $xid );
	echo "'>$t</a>&nbsp;&nbsp;\n";
	$t = $_maint;
	if( $is_maint ) $t = "$fn_memb $_ismaint";
	echo "<a href='".lnkxid( '/maintainer.phtml', $xid );
	echo "'>$t</a>";
	while( list( $k, $t ) = each( $_lk2 )){
		echo "&nbsp;&nbsp;\n";
		echo add_xid( $t, $xid );
	}
	echo "<br>&nbsp;</font>\n";
}

function elim_tags( $str ){
	$i = strpos( $str, "<" );
#	if( is_string( $i )) return $str;	# $i is a string if not found
	if(( substr( $str, 0, 1 ) != '<' ) && !$i ) return $str;
	$i += 1;
	$len = strlen( $str );
	while( ( $i > 0 ) && ( $i < $len )){
		if( $i = strpos( $str, ">", $i ) + 1 ){
			if( !$j = strpos( $str, "<", $i )) $j = $len;
			$t = $t.substr( $str, $i, $j-$i );
		}
		$i = strpos( $str, "<", $i );
	}
	return $t;
}

function htmlhead( $title, $keyw ){
	global $_text, $_page, $_link, $_vlink, $_alink, $_title, $fqdomain;
	$title = elim_tags( $title );
	echo "<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN' ";
	echo "'http://www.w3.org/TR/html4/loose.dtd' >\n";
	echo "<html>\n<head>\n<meta http-equiv='content-type' ";
	echo "content='text/html; charset=iso-8859-1'>\n";
	echo "<meta http-equiv='pragma' content='nocache'>\n";
	echo "<meta http-equiv='expires' content='0'>\n";
	echo "<meta name='author' content='Stefan Meretz'>\n";
	echo "<meta name='description' content='$_title: $title'>\n";
	if( !empty( $keyw )) echo "<meta name='keywords' content='$keyw'>\n";
	echo "<title>$_title: $title</title>\n";
	echo "<link rel='shortcut icon' href='/images/favicon.ico'>\n";
	echo "</head>\n<body text='$_text' bgcolor='$_page' ";
	echo "link='$_link' vlink='$_vlink' alink='$_alink'>\n";
}

function foot() {
	global $fqdomain, $PHP_SELF, $maildom, $ot_maint, $_src, $_who, $_fontfoot, $xid;
	$link = 'http://'.$fqdomain.$PHP_SELF;
	$lastmod = getlastmod();
	$tag = date("j", $lastmod);
	if( strlen( $tag ) == 1 ) $tag = "0".$tag;
	$mon = date("M", $lastmod);
	$jahr = date("Y", $lastmod);
	$std = date("H", $lastmod);
	$min = date("i", $lastmod);
	switch ($mon) {
		case "Jan": $mon = "01"; break;
		case "Feb": $mon = "02"; break;
		case "Mar": $mon = "03"; break;
		case "Apr": $mon = "04"; break;
		case "May": $mon = "05"; break;
		case "Jun": $mon = "06"; break;
		case "Jul": $mon = "07"; break;
		case "Aug": $mon = "08"; break;
		case "Sep": $mon = "09"; break;
		case "Oct": $mon = "10"; break;
 		case "Nov": $mon = "11"; break;
		case "Dec": $mon = "12"; break;
		default: $mon = "??";
	}
	echo "<br>\n<font $_fontfoot>\n<hr size='1' noshade width='100%'>\n<center>\n";
	echo "<br>$_src: <a href='".lnkxid( $link, $xid )."'>$link</a>\n";
	echo "<br>$_who: <a href=\"mailto:$ot_maint@$maildom\">$ot_maint@$maildom</a>\n";
	echo "<br><i>(Last Software Update: $tag.$mon.$jahr, $std:$min)</i></center></font>\n";
	echo "</body>\n</html>\n";
}

function new_user( $em, $wd, $page ){
	global $_fontbulk, $_fontinpt, $_fonthdln, $link_rules, $_bg5, $_x;
	htmlhead( 'New User', '' );
	$more = "<img src='/images/more.png' width='12' height='12' border='0' alt=''>&nbsp;\n";
	echo "<center>\n";
	menu( '', 0 );
	echo "</center>\n<br>\n<font $_fonthdln>\n";
	eval( "\$x = \"$_x[0]\";" );
	echo "<center><b>$x</b></center></font>\n<br>\n";
	echo "<table width='100%' cellpadding='4'>\n";
	echo "<tr>\n<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
	echo "<b>$_x[1]</b></font></td></tr>\n";
	echo "<tr>\n<td>\n<font $_fontbulk>\n$more";
	$email = urlencode( $em );
	eval( "\$x = \"$_x[2]\";" );
	echo "$x<br>&nbsp;</font></td><tr>\n";
	echo "<tr>\n<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
	echo "<b>$_x[3]</b></font></td></tr>\n";
	echo "<tr>\n<td>\n<font $_fontbulk>\n$more";
	eval( "\$x = \"$_x[4]\";" );
	echo "$x<br>&nbsp;</font></td></tr>\n";
	echo "<tr>\n<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
	echo "<b>$_x[5]</b></font></td></tr>\n";
	echo "<tr>\n<td>\n<font $_fontbulk>\n$more";
	echo "$_x[6]\n<center><form action='/member.phtml' method='post'>\n";
	echo "<table>\n<tr>\n<td>\n<font $_fontinpt>\n";
	echo "<input type='text' name='e_new' size='25' maxlength='80' value='$em'>";
	echo "</font></td></tr>\n<tr>\n<td align='center'>\n<font $_fontbulk>\n";
	echo "<input type='hidden' name='action' value='new_pw'>\n";
	echo "<input type='hidden' name='xid' value='1'>\n";
	echo "<input type='submit' value='$_x[7]'>";
	echo "</font></td></tr></table></form></center>\n</font></td></tr>\n";
	echo "<tr>\n<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
	echo "<b>$_x[8]</b></font></td></tr>\n";
	echo "<tr>\n<td>\n<font $_fontbulk>\n$more";
	echo "$_x[9]</font></td></tr>\n";
	echo "<tr>\n<td align='center'>\n<font $_fontbulk>\n";
	echo "<form action='/member.phtml' method='post'>\n";
	echo "<table>\n<tr>\n<td>\n";
	echo "<font $_fontbulk>\n$_x[10]:</font></td>\n";
	echo "<td>\n<font $_fontinpt>\n";
	echo "<input type='text' name='fn_new' size='20' maxlength='30'>";
	echo "</font></td>\n<td>\n<font $_fontinpt>\n";
	echo "<input type='text' name='ln_new' size='20' maxlength='50'>";
	echo "</font></td></tr>\n<tr>\n<td>\n";
	echo "<font $_fontbulk>\n$_x[11]:</font></td>\n";
	echo "<td>\n<font $_fontinpt>\n";
	echo "<input type='text' name='e_new' size='20' maxlength='80' value='$em'>";
	echo "</font></td>\n<td>\n<font $_fontinpt>\n";
	echo "<input type='password' name='wd_new' size='20' maxlength='80' value='$wd'>";
	echo "</font></td></tr>\n<tr>\n<td colspan='3' align='center'>\n";
	echo "<font $_fontbulk>\n";
	echo "<input type='hidden' name='action' value='welcome'>\n";
	echo "<input type='hidden' name='xid' value='1'>\n";
	echo "<input type='submit' value='$_x[12]'>";
	echo "</font></td></tr></table></form>\n";
	echo "</font></td></tr>\n<tr>\n<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
	echo "<b>$_x[13]</b></font></td></tr>\n";
	echo "<tr>\n<td>\n<font $_fontbulk>\n$more";
	eval( "\$x = \"$_x[14]\";" );
	echo "$x</font></td></tr>\n</table\n";
	foot();
}

function insert_session( $xid, &$xpar ){
	if( empty( $xid )) return( FALSE );
	$qry = "select memb_id, first_n, last_n, email, subscr, lang ";
	$qry .= "from member where x_id = $xid";
	if( !$id = mysql_query( $qry )) errlog( $qry, 56, 7 );
	if( $row = mysql_fetch_array( $id )){
		$mid = $row[ 'memb_id' ];
		$xem = $row[ 'email' ];
		$xfn = $row[ 'first_n' ];
		$xln = $row[ 'last_n' ];
		$xdt = $row[ 'subscr' ];
		$xlg = $row[ 'lang' ];
		$acc = date( 'Y-m-d G:i:s' );
		$xmt = 0;
		$qry = "select ismaint from projmemb where ismaint = 1 ";
		$qry .= "and memb_id = $mid";
		if( !$id = mysql_query( $qry )) errlog( $qry, 57, 7 );
		if( $row = mysql_fetch_array( $id )) $xmt = 1;
		srand((double)microtime()*1000000);
		$xid = rand();
		$qry = "insert into session values( $xid, $mid, ";
		$qry .= "'$acc', '$xfn', '$xln', '$xem', $xmt, '$xdt', '$xlg' )";
		if( !mysql_query( $qry )) errlog( $qry, 58, 7 );
		$xpar[ 'acc' ] = $acc;
		$xpar[ 'mid' ] = $mid;
		$xpar[ 'xfn' ] = $xfn;
		$xpar[ 'xln' ] = $xln;
		$xpar[ 'xem' ] = $xem;
		$xpar[ 'xmt' ] = $xmt;
		$xpar[ 'xdt' ] = $xdt;
		$xpar[ 'xlg' ] = $xlg;
		return( $xid );
	}
	return( FALSE );
}

function read_session( $xid, &$xpar ){
	global $xidval;
	if( empty( $xid )) return( FALSE );
	$qry = "select * from session where x_id = $xid";
	if( !$id = mysql_query( $qry )) errlog( $qry, 59, 7 );
	if( !$row = mysql_fetch_array( $id )){
		return( insert_session( $xidval, $xpar ));
	} else {
		$xpar[ 'acc' ] = $row[ 'lacc' ];
		$xpar[ 'mid' ] = $row[ 'm_id' ];
		$xpar[ 'xfn' ] = $row[ 'xfn' ];
		$xpar[ 'xln' ] = $row[ 'xln' ];
		$xpar[ 'xem' ] = $row[ 'xem' ];
		$xpar[ 'xmt' ] = $row[ 'xmt' ];
		$xpar[ 'xdt' ] = $row[ 'xdt' ];
		$xpar[ 'xlg' ] = $row[ 'xlg' ];
	}
	return( $xid );
}

function logout_by_button( $xidval) {
	setcookie( 'xidval', '0', 0, '/' );	# delete cookie
	if( !empty( $xidval )) {
		$qry = "delete from session where x_id = $xidval";
		if( !mysql_query( $qry )) errlog( $qry, 60, 7 );
	}
}

function login_by_cookie( $xid, $txt, &$par, &$msg ) {
	global $_fontfoot, $_fg3;
	if( $xid = insert_session( $xid, $par )){
		$msg = "<tr>\n<td align='center' colspan='2'>\n";
		$msg .= "<font $_fontfoot color='$_fg3'>\n";
		$msg .= "*&nbsp;$txt&nbsp*</font></td></tr>\n";
		return( $xid );
	}
	return( FALSE );
}

function login_by_form( $xem, $xwd, $x, &$par, &$msg ) {
	global $PHP_SELF, $_fontfoot, $_fg3;
	if( empty( $xwd )){
		new_user( $xem, '', $PHP_SELF );
		return( FALSE );
	} elseif( !check_email( $xem )){
		if( !empty( $x )) {
			$msg = "<tr>\n<td align='center' colspan='2'>\n";
			$msg .= "<font $_fontfoot color='$_fg3'>\n";
			$msg .= "*&nbsp;$x[6]&nbsp;*</font></td></tr>\n";
		}
	} else {
		$qry = "select memb_id from member where email = '$xem'";
		if( !$id = mysql_query( $qry )) errlog( $qry, 61, 7 );
		if( !$row = mysql_fetch_array( $id )){
			new_user( $xem, $xwd, $PHP_SELF );
			return( FALSE );
		}
		$qry = "select memb_id, first_n, last_n, passwd, subscr, lang ";
		$qry .= "from member where email = '$xem' and passwd = password( '$xwd' )";
		if( !$id = mysql_query( $qry )) errlog( $qry, 62, 7 );
		if( !$row = mysql_fetch_array( $id )){
			if( !empty( $x )) {
				$msg = "<tr>\n<td align='center' colspan='2'>\n";
				$msg .= "<font $_fontfoot color='$_fg3'>\n";
				$msg .= "*&nbsp;$x[7]&nbsp;*</font></td></tr>\n";
			}
		} else {
			$mid = $row[ 'memb_id' ];
			$xfn = $row[ 'first_n' ];
			$xln = $row[ 'last_n' ];
			$xdt = $row[ 'subscr' ];
			$xlg = $row[ 'lang' ];
			$xmt = 0;
			$qry = "select ismaint from projmemb where ismaint = 1 ";
			$qry .= "and memb_id = $mid";
			if( !$id = mysql_query( $qry )) errlog( $qry, 63, 7 );
			if( $row = mysql_fetch_array( $id )) $xmt = 1;
			srand((double)microtime()*1000000);
			$xid = rand();				# cookie value
			$qry = "update member set x_id = $xid where memb_id = $mid";
			if( !mysql_query( $qry )) errlog( $qry, 64, 7 );
			setcookie( 'xidval', $xid, time()+2419200, '/' ); # valid 4 weeks
			srand((double)microtime()*1000000);
			$xid = rand();				# session id
			$qry = "insert into session values( $xid, $mid, now(), ";
			$qry .= "'$xfn', '$xln', '$xem', $xmt, '$xdt', '$xlg' )";
			if( !mysql_query( $qry )) errlog( $qry, 65, 7 );
		}
	}
	$par[ 'mid' ] = $mid;
	$par[ 'xfn' ] = $xfn;
	$par[ 'xln' ] = $xln;
	$par[ 'xem' ] = $xem;
	$par[ 'xmt' ] = $xmt;
	$par[ 'xdt' ] = $xdt;
	$par[ 'xlg' ] = $xlg;
	return( $xid );
}

function page_move( $xid, $txt, &$par ) {
	global $_fontfoot, $_fg3;
	if( !$xid = read_session( $xid, $xpar )){
		$msg .= "<tr>\n<td align='center' colspan='2'>\n";
		$msg .= "<font $_fontfoot color='$_fg3'>\n";
		$msg .= "*&nbsp;$txt&nbsp;*</font></td></tr>\n";
		setcookie( 'xidval', '0', 0, '/' ); # delete cookie
		return( FALSE );
	} else {
		$par[ 'mid' ] = $xpar[ 'mid' ];
		$par[ 'xem' ] = $xpar[ 'xem' ];
		$par[ 'xmt' ] = $xpar[ 'xmt' ];
		$par[ 'xdt' ] = $xpar[ 'xdt' ];
		$par[ 'xlg' ] = $xpar[ 'xlg' ];
		if( empty( $par[ 'xfn' ])) $par[ 'xfn' ] = $xpar[ 'xfn' ];
		if( empty( $par[ 'xln' ])) $par[ 'xln' ] = $xpar[ 'xln' ];
		$t = $xpar[ 'acc' ];
		list( $yy, $mo, $dd ) = split( '-', substr( $t, 0, 10 ));
		list( $hh, $mm, $ss ) = split( ':', substr( $t, -8 ));
		$t = time() - mktime( $hh, $mm, $ss, $mo, $dd, $yy );
		if( $t > 360 ) {	# update timestamp every ten minutes
			$qry = "update session set lacc = now() ";
			$qry .= "where x_id = $xid";
			if( !mysql_query( $qry )) errlog( $qry, 66, 7 );
		}
	}
	return( $xid );
}

function head( $text, $keyw, &$xid, &$par ) {
	global $PHP_SELF, $_x, $_fontbulk, $_fontfoot, $_fonthdln, $_fg2, $_bg5,
	$fqdomain, $skip, $logout, $lang, $langs,
	$xem, $xwd, $xidval;	# xem: email by form, xwd: passwd by form, xidval: cookie
	$x = explode( '#', $_x[15] );
	$msg = '';
#	$msg = "xidval=$xidval, xid=$xid, $xem, $xwd";

	if( empty( $skip )){

		# logout by button click
		if( $logout ){
			logout_by_button( $xidval );
			$xid = '';
			$xidval = '';
		}

		# login by cookie
		if( empty( $xid ) && ( $xidval > 0 )){	# check cookie
			$xid = login_by_cookie( $xidval, $x[5], $par, $msg );
		}

		# login by form
		if( empty( $xid ) && !empty( $xem )) {
			$xid = login_by_form( $xem, $xwd, $x, $par, $msg );
		}

		# user has moved to another page
		if( !empty( $xid ) && empty( $xem )) {
			$xid = page_move( $xid, $x[8], $par );
		}
	}

	$par[ 'ppt' ] = get_global( 'pjpts' );
	$text = eregi_replace( '"', '\"', $text );
	$xfn = $par[ 'xfn' ];	# may be interpreted by eval
	$xln = $par[ 'xln' ];	# dito
	$xem = $par[ 'xem' ];	# dito
	eval( "\$text = \"$text\";" );
	htmlhead( $text, $keyw );
	echo "<table width='100%'>\n";
	echo "<tr>\n<td width='90%' align='center'>\n";
	menu( $xfn, $par[ 'xmt' ]);
	if( isset( $text )) {
		echo "<br>\n<font $_fonthdln>\n<b>";
		echo add_xid( $text, $xid )."</b></font>\n";
	}
	echo "</td>\n<td width='10%' bgcolor='$_bg5' align='center'>\n";
	echo "<table bgcolor='$_bg5'>\n";
	$l = empty( $lang ) ? $PHP_SELF : "$PHP_SELF?lang=$lang";
	echo "<form action='$l' method='post'>\n";
	$text = '';
	reset( $langs );
	if( empty( $lang  )) $lang = key( $langs );
	while( list( $k, $l ) = each( $langs )) {
		if( $k != $lang ) {
			$text .= "&nbsp;<a href='$PHP_SELF";
			$text .= empty( $xid ) ? "?lang=$k" : "?xid=$xid&lang=$k";
			if( !empty( $par[ 'add' ])) $text .= '&'.$par[ 'add' ];
			$text .= "'><img src='/images/flag$k.png' ";
			$text .= "border='0' title='$l' alt='$l'></a>";
		}
	}
	if( empty( $xid )) {
		echo "$msg<tr>\n<td>\n<font $_fontbulk>\n";
		echo "$x[0]:</font></td>\n<td>\n<font $_fontbulk>\n";
		echo "<input type='text' name='xem' size='10' maxlength='80' value='$xem'>";
		echo "</font></td></tr>\n<tr>\n<td>\n<font $_fontbulk>\n";
		echo "$x[1]:</font></td>\n<td>\n<font $_fontbulk>\n";
		echo "<input type='password' name='xwd' size='10' maxlength='50'>";
		echo "</font></td></tr>\n";
		echo "<tr>\n<td>\n<font $_fontfoot>\n";
		echo "<input type='submit' value='$x[2]'></font></td>\n";
		echo "<td align='right'>$text</td></tr></form></table>\n";
	} else {
		echo "$msg<tr>\n<td colspan='2'>\n<font $_fontfoot>\n";
		echo "<font color='$_fg2'>\n$x[4]:</font>\n";
		echo "<br>$xfn $xln<br>$xem</font></td></tr>\n";
		echo "<tr>\n<td>\n<font $_fontfoot>\n";
		echo "<input type='hidden' name='logout' value='1'>";
		echo "<input type='submit' value='$x[3]'></font></td>\n";
		echo "<td align='right'>$text</td></tr></form></table>\n";
	}
	echo "</td></tr></table>\n";
	return( TRUE );
}
?>
