package ot_activity;
use strict;
#use FindBin;					# if it works: use FinBin
#use lib $FindBin::Bin;				# instead of static path
use lib '/data/httpd/opentheory/otperl';	# or: adjust path

use ot_dblib qw( &db_update_global &db_select_col &db_select_row );
#use ot_maillib qw( &debug );
use vars qw( @ISA @EXPORT_OK $VERSION );
use Exporter;
$VERSION = 1.01;
@ISA = qw(Exporter);
@EXPORT_OK = qw(
&calc_actval
&calc_activity
);

=head1 NAME

ot_activity - provides function to calcute the activity

=head1 SYNOPSIS

Calculates the activity recursively

=head1 DESCRIPTION

The activity is calculated und updated for a given project. If this project
has sub-project, then the activity is calculated using all subproject. The
top-project always represents the activity sum of all project in the tree.

=cut

=head2 calc_actval - checks one activity value using global max points

in-param:	$dbh - database handle
in-param:	$activ - activity points
in-param:	$maxpts - global max points
returns:	activity in percent

=cut

sub calc_actval {
	my( $dbh, $actpts, $maxpts ) = @_;
	if( $actpts < 0 ){
		$actpts = 0;
	}
	elsif( $actpts > $maxpts ){
		$maxpts = $actpts;
		db_update_global( $dbh, 'pjpts', $maxpts );
	}
	return( $actpts * 100 / $maxpts );
}

=head2 calc_activity - calculates the activity point sum of all sub/projects

in-param:	$dbh - database handle
in-param:	$plist - list of project ids of sub/projects
in-param:	$maxpts - global max points
returns:	activity in percent

=cut

sub calc_activity {
	my( $dbh, $plist, $maxpts ) = @_;
	my $col = 'max( membnum )*10 + sum( mailnum )*10 + sum( commnum )*10 + sum( clicnum ) ';
	$col .= '- sum( to_days(now()) - to_days(submit) ) points';
	my %r = db_select_row( $dbh, 'metatext', $col, "proj_id in $plist" );
	if( exists( $r{points} )) {
		return( calc_actval( $dbh, $r{points}, $maxpts ));
	}
	return 0;
}
1;