package ot_aut;
use strict;
use Apache::Constants qw( OK DECLINED REDIRECT AUTH_REQUIRED );
#use FindBin;					# if it works: use FinBin
#use lib $FindBin::Bin;				# instead of static path
use lib '/data/httpd/opentheory/otperl';	# or: adjust path

use ot_const qw( %ot );
use ot_dblib qw( &db_connect &db_disconnect );

=head1 NAME

ot_aut - authenticates admin access via web

=head1 SYNOPSIS

The handler is called by apache and authenticates user.

=head1 DESCRIPTION

All functions and procedures are described below.

=head2 handler - checks user request against database

S<in-param:	user request
returns:	status OK or AUTH_REQUIRED (apache constants)>

=cut

sub handler {
	my $request = shift;
	my ( $res, $send_pw ) = $request->get_basic_auth_pw;
	my $ret = AUTH_REQUIRED;
	my $user = $request->connection->user;
	if( !$user ) {
		return OK;
	}
	open( LH , '>>'.$ot{logpath}.'auth.log' ) || die 'error open log';
	print LH 'auth access at '.localtime()." by $user pw '$send_pw'\n";
	close( LH );
	my $dbh = db_connect;
	my $qry = "select memb_id from member where email='$user' ";
	$qry .= "and passwd = password( '$send_pw' )";
	my $query = $dbh->prepare( $qry );
	$query->execute();
	if( $query->fetchrow_hashref()){
#		$pw = $$row{'passwd'};
		$ret = OK;
	}
	$query->finish();
	db_disconnect( $dbh );
	return $ret;
}
1;
