#!/usr/bin/perl -w
use strict;
#use FindBin;					# if it works: use FinBin
#use lib $FindBin::Bin;				# instead of static path
use lib '/data/httpd/opentheory/otperl';	# or: adjust path

use ot_const qw( %r &is &res &is_err $session );
use ot_maillib qw( &debug );
use ot_receive qw( &receive );

=head1 NAME

ot_mail.pl - general mail interface of open theory

=head1 SYNOPSIS

Receives, analyzes and executes mail commands.

=head1 DESCRIPTION

Commands are received by mail. They are analyzed, stored, validated and
executed. The result is send to the user by mail.

=cut

my $res;
my $msg_id;
my $from;

$session = int( rand( 1000 ));
debug( "##### Start ot_mail.pl: ".localtime, 0 );

( $res, $msg_id, $from ) = receive();
debug( 'receive-result: '.res( $res ), 1 );

if(( $res == $r{mail_loop} )				# will hopefully never happen
	|| ( $res == $r{ok} )				# should never happen, too unspecific
	|| ( $res == $r{ok_nothing_done} )) {		# normal
	exit;
}

if( !is_err( $res )){
	if( $res == $r{ok_ab_mode} ) {			# address-based mode
		require ot_parse_a;
		ot_parse_a->import( qw( &parse ));
	} elsif( $res == $r{ok_bb_mode} ) {		# body-based mode
		require ot_parse_b;
		ot_parse_b->import( qw( &parse ));
	}
}

if( !is_err( $res )){
	$res = parse( $msg_id );
	debug( 'parse-result: '.res( $res ), 1 );
}

if( !is_err( $res )){
	require ot_validate;
	ot_validate->import( qw( &validate ));
	$res = validate( $msg_id );
	debug( 'validate-result: '.res( $res ), 1 );
}

require ot_execute;
ot_execute->import( qw( &execute ));
$res = execute( $msg_id );
debug( 'execute-result: '.res( $res ), 1 );

debug( "#### End ####\n", 0 );
