#!/usr/bin/perl
use strict;
#use FindBin;					# if it works: use FinBin
#use lib $FindBin::Bin;				# instead of static path
use lib '/data/httpd/opentheory/otperl';	# or: adjust path

use ot_const qw( %ot &res $session );
use ot_dblib qw( &db_connect &db_disconnect &db_count &db_delete
&db_update_col &db_select_col &db_select_row &db_select_val
&db_cursor_open &db_cursor_get &db_cursor_close
&db_get_msg &db_get_pidlist &db_insert_receive &db_insert_cmd );
use ot_activity qw( &calc_activity &calc_actval );
use ot_maillib qw( &debug &mail &mailerror );
use ot_execute qw( &execute );

=head1 NAME

ot_sender - sends comments to mailing lists

=head1 SYNOPSIS

Reads table par_mail and sends all mails to corresponsing mailinglists.

=head1 DESCRIPTION

The table par_mail is read, and all mails are send to the corresponding
mailing lists. This function is usually called by a cron job.

=cut

my $admin = $ot{listmaster};

my @mailtext;	# mail text array
my @mailaddr;
my @pid;	# pers_id array
my $p;
my @mid;	# memb_id array
my $m;
my $email;
my $para1;	# paragraph number
my $para2;	# paragarph number
my $pjname;
my $pjnlow;
my $addr_to;
my $txt;
my $dbh;	# database handle
my $query;	# query object
my $qstr;	# sql query string
my $row;	# one fetched row
my $pid;	# project id (got from list name)
my $subj;	# subject of the header
my %rec;
my $rec_id;
my $cmd_id;
my @all_id;
my $msg_id;
my %msg;
my $dat;
my $res;
my $i;
my $pts;	# global points
my $ver;	# version number
my $st;		# status
my $ma;		# mail number
my $co;		# comment/paragraph number
my $cl;		# clic number
my $tt;		# actrate
my $whr;	# where clause
my $cur;	# cursor

#### html2mail
sub html2mail {
	$_ = pop( @_ );
#	s/\s*\n\s*/ /g;		# replace newlines
	s/<li>/\n- /gi;		# replace <li>'s with '\n- '
#	s/<[^>]*>//g;		# elim tags - kills email address:-(
#	s/\\('|"|\\)/$1/g;	# strip backslashes
	s/&auml;//g;
	s/&Auml;//g;
	s/&ouml;//g;
	s/&Ouml;//g;
	s/&uuml;//g;
	s/&Uuml;//g;
	s/&szlig;//g;
	return $_;
}

#################################################################################

$session = int( rand( 1000 ));
debug( "##### Start ot_sender.pl: ".localtime, 0 );

$dbh = db_connect;	# database handle
%msg = db_get_msg( $dbh, 10, 'de' );

$qstr = "select proj_id, memb_id from par_mail group by proj_id, memb_id";
debug( $qstr, 1 );
$query = $dbh->prepare( $qstr );
$query->execute();
while ( $row = $query->fetchrow_hashref() ) {
	push( @pid, $row->{'proj_id'} );
	push( @mid, $row->{'memb_id'} );
}
$query->finish();

foreach $m ( @mid ){
	$p = shift( @pid );	# take from end
	push( @pid, $p );	# put on top
	debug( "pid=$p, mid=$m", 1 );
	$i = 0;
	$txt = '';
	$para1 = '';
	$para2 = '';
	$qstr = "select first_n, last_n, email from member where memb_id = $m";
	debug( $qstr, 1 );
	$query = $dbh->prepare( $qstr );
	$query->execute();
	$row = $query->fetchrow_hashref();
	$query->finish();
	if ( !( $row->{'first_n'} )) {
		mailerror( "ot_sender: select 1 returns empty set:\n$qstr" );
		$m = 0;		# user has left, set to anonymous
	} else {
		$email = "\"$row->{'first_n'} $row->{'last_n'}\" ";
		$email .= "<$row->{'email'}>";
	}
	$query->finish();
	$qstr = "select p.parastr, p.subj, p.text, p.ctext, t.titlabb ";
	$qstr .= "from par_mail p, metatext t where p.proj_id = t.proj_id ";
	$qstr .= "and p.proj_id = $p and p.memb_id = $m and t.status = 'act' ";
	$qstr .= "order by p.parastr";
	debug( $qstr, 1 );
	$query = $dbh->prepare( $qstr );
	$query->execute();
	while ($row = $query->fetchrow_hashref() ) {
		$para2 = $para1;		# save last paranum
		$para1 = $row->{'parastr'};
		$para1 = substr( $para1, 0, length( $para1 )-5 );
		if( $i == 0 ){
			$pjname = $row->{'titlabb'};
			$pjnlow = $pjname;
			$pjnlow =~ tr/[A-Z]/[a-z]/;	# transform to lower case
			$subj = $row->{'subj'};
			$addr_to = qq("$msg{1} $pjname" <$pjnlow\@$ot{maildom}>);
			if(( $m == 0 ) && ( substr( $row->{'text'}, 0, 7 ) ne 'Ano Nym' )){
				$_ = $row->{'text'};
				/(<.+\@.+>)/;
				$email = "$msg{6} $1";	### noch email rausfiddeln
			}
		}
		if( $para1 ne $para2 ) {		# print only if new para
			$txt .= html2mail( $row->{'text'} )."\n";
		}
		$txt .= html2mail( $row->{'ctext'} )."\n";
		$i++;
	}
	$query->finish();
	if( $i > 1 ) { $subj = "$msg{1} '$pjname'" };
	$msg_id = 'sender'.int(rand( 10000000000 ));
	push( @all_id, $msg_id );
	$dat = localtime;
	$subj =~ s/(['"])/\\$1/g;	# backslash quotes
	%rec = (
		msg_id		=> $msg_id,
		proj_addr	=> $pjnlow,
		proj_id		=> $p,
		addr_to		=> $addr_to,
		subject		=> $subj,
		sender		=> $email,
		memb_id		=> $m,
		send		=> $dat,
		body		=> 'unused'
	);
	if( !( $rec_id = db_insert_receive( $dbh, %rec ))) {
		db_disconnect( $dbh );
		mailerror( "ot_sender: error inserting receive record" );
		exit;
	}
	$cmd_id = int( rand( 1000000000 ));
	$txt =~ s/(['"])/\\$1/g;	# backslash quotes
	if( !( db_insert_cmd( $dbh, $rec_id, $cmd_id, 1, 'maillist', $txt ))) {
		db_disconnect( $dbh );
		mailerror( "ot_sender: error inserting command record" );
		exit;
	}
}

# save sent mail => security reasons only
$qstr = "insert into par_mail_sav( mdate, proj_id, memb_id, parastr, subj, text, ctext ) ";
$qstr .= "select mdate, proj_id, memb_id, parastr, subj, text, ctext from par_mail";
debug( $qstr, 2 );
$query = $dbh->prepare( $qstr );
$query->execute();

# delete mail queue
if( !db_delete( $dbh, 'par_mail' )){
	mailerror( "ot_sender: error deleting mail queue (table par_mail)" );
}
foreach $msg_id ( @all_id ){
	$res = execute( $msg_id );
	debug( 'execute-result: '.res( $res ), 1 );
}

# delete sessions
if( !db_delete( $dbh, 'session' )){
	mailerror( "ot_sender: error deleting sessions (table session)" );
}

# check receive and command tables
if( db_count( $dbh, 'receive' ) || db_count( $dbh, 'command' )){
	mailerror( "ot_sender: error left entries in tables receive/command" );
}

# next step: calculate points
$pts = db_select_val( $dbh, 'global', 'pjpts' );
$txt = 'membnum*10 + mailnum*10 + commnum*10 + clicnum - to_days(now()) + to_days(submit) points';
$cur = db_cursor_open( $dbh, 'metatext', "proj_id, vers_id, status, commnum, $txt" );
%rec = db_cursor_get( $cur );
$res = exists( $rec{proj_id} );
while( $res ) {
	$pid = $rec{proj_id};
	$ver = $rec{vers_id};
	$st = $rec{status};
	$co = $rec{commnum};
	$i = $rec{points};
	$whr = "proj_id = $pid and vers_id = $ver";

	# just checking
	$m = db_count( $dbh, 'paragraph', $whr );
	if( $m != $co ){	# should never happen
#		mailerror( "ot_sender: error wrong commnum: $m <> $co\nwhere $whr" );
		$co = $m;
		if( !db_update_col( $dbh, 'metatext', 'commnum', $co, $whr )){
			mailerror( "ot_sender: error updating metatext.commnum: $co\nwhere $whr" );
		}
	}
	if( $st eq 'act' ){			# recursive calculation
		$txt = "( $pid";
		$txt = db_get_pidlist( $dbh, $pid, $txt );
		$txt .= ' )';
		$tt = calc_activity( $dbh, $txt, $pts );
	}
	else {					# simple calculation
		$tt = calc_actval( $dbh, $i, $pts );
	}
	if( !db_update_col( $dbh, 'metatext', 'actrate', $tt, $whr )){
		mailerror( "ot_sender: error updating metatext.actrate: $tt\nwhere $whr" );
	}	
	%rec = db_cursor_get( $cur );
	$res = exists( $rec{proj_id} );
}
db_cursor_close( $cur );

# update global statistics
$ma = db_count( $dbh, 'member' );				# member
@mid = db_select_col( $dbh, 'projmemb', 'distinct( memb_id )', 'ismaint = 1' );
$m = $#mid + 1;							# maintainer
$p = db_count( $dbh, 'metatext', 'pjtype > 1' );		# project num
$i = db_count( $dbh, 'paragraph' );				# total paranum
$co = db_count( $dbh, 'paragraph', 'length( parastr ) > 7 ' );	# comments
$i -= $co;							# text paras
$cl = db_select_val( $dbh, 'metatext', 'sum( clicnum )' );	# total clicnum
$txt = "now(), mbnum = $ma, mtnum = $m, pjnum = $p, panum = $i, conum = $co, clnum = $cl";
if( !db_update_col( $dbh, 'global', 'gdate', $txt )){
	mailerror( "ot_sender: error updating global:\ngdate = $txt" );
}

# update maintainer project numbers
if( !db_update_col( $dbh, 'member', 'pjnumb', '0' )){
	mailerror( "ot_sender: error updating member.pjnumb: 0" );
}	
$cur = db_cursor_open( $dbh, 'metatext where pjtype > 1 group by memb_id', 'memb_id, count( memb_id ) num' );
%rec = db_cursor_get( $cur );
$res = exists( $rec{memb_id} );
while( $res ) {
	$i = $rec{num};
	$whr = 'memb_id = '.$rec{memb_id};
	if( !db_update_col( $dbh, 'member', 'pjnumb', $i, $whr )){
		mailerror( "ot_sender: error updating member.pjnumb: $i\nwhere $whr" );
	}	
	%rec = db_cursor_get( $cur );
	$res = exists( $rec{memb_id} );
}
db_cursor_close( $cur );

db_disconnect( $dbh );
debug( "#### End ####\n", 0 );
