package ot_validate;
use strict;
#use FindBin;					# if it works: use FinBin
#use lib $FindBin::Bin;				# instead of static path
use lib '/data/httpd/opentheory/otperl';	# or: adjust path

use ot_const qw( %ot %r %f &is &is_err %opt );
use ot_maillib qw( &mail &debug &mailerror &usermail &split_email_addr );
use ot_dblib qw( &db_connect &db_disconnect &db_select_col &db_select_row
&db_pj_member &db_is_member &db_is_maintainer &db_has_maillist &db_get_memb_id 
&db_is_project &db_set_status &db_is_super );
use vars qw(@ISA @EXPORT_OK $VERSION);
use Exporter;
$VERSION = 1.00;
@ISA = qw(Exporter);
@EXPORT_OK = qw( &validate );

=head1 NAME

ot_validate - validates key-value-pairs

=head1 SYNOPSIS

Scans table 'command', validates key-value pairs and
requests user for confirmation if necessary.

=head1 DESCRIPTION

All functions and procedures are described below.

=head2 eval_command - evaluates a command

S<in-param:	$dbh - database handle
in-param:	$cid - id of the command record
in-param:	$pid - command and evt. projectname
in-param:	$mid - member Id (0, if not a ot-member)
in-param:	$cmd - command
in-param:	$arg - argument (value)
returns:	$status - processing status>

=cut

sub eval_command {
	my( $dbh, $cid, $pid, $mid, $cmd, $arg ) = @_;
	my $status = $r{ok};
	my( $p, $m ) = ( 0, 0 );

	# checks, if command is implemented
	if( !is_err( $status ) && is( $cmd, $f{not_implemented} )){
		$status = $r{not_implemented};
	}

	# validate ot-membership, if necessary
	if( !is_err( $status ) && is( $cmd, $f{ot_members_only} )
		&& ( $mid == 0 )) {
		$status = $r{not_ot_member};
	}

	# validate pj-membership, if necessary
	if( !is_err( $status ) && is( $cmd, $f{pj_members_only} )
		&& ( $pid > 0 ) && !db_is_member( $dbh, $pid, $mid )) {
		$status = $r{not_pj_member};
	}
		
	# validate pj-maintainer, if necessary
	if( !is_err( $status ) && is( $cmd, $f{pj_maint_only} )
		&& ( $pid > 0 ) && !db_is_maintainer( $dbh, $pid, $mid )) {
		$status = $r{not_maintainer};
	}

	# validate ml-member, if necessary
	if( !is_err( $status ) && is( $cmd, $f{ml_members_only} )
		&& ( $pid > 0 ) && !db_has_maillist( $dbh, $pid, $mid )) {
		$status = $r{hasnt_maillist};
	}

	if( !is_err( $status )) {

		# single checks
		$_ = $cmd;

		if( /unsubscribe/ ){
			if( $pid < 0 ){		# user wants to unsubscribe from ot
				if( db_pj_member( $dbh, $mid )){
					$status = $r{yet_pj_member};
				}
			}			# unsubscribe only if not maintainer
			elsif( db_is_maintainer( $dbh, $pid, $mid )) {
				$status = $r{yet_maintainer};
			}
		}

		elsif( /subscribe/ ) {		# check if already member of ot or pj
			if( $pid < 0 ){		# user only want subscribe ot
				if( $mid > 0 ){
					$status = $r{already_ot_memb};
				}
			}			# user want subscribe a project
			elsif( db_is_member( $dbh, $pid, $mid )) {
				$status = $r{already_pj_memb};
			}
		}
		
		elsif( /setoption/ ) {
			$_ = $arg;
			/(.+)=(.+)/;
			if( !exists( $opt{$1} )){
				$status = $r{invalid_option};
			}
			elsif(( $2 ne 'y' ) && ( $2 ne 'n' )){
				$status = $r{invalid_yesno};
			}
		}

		elsif( /send/ ) {	# send can only be used by system/superuser
			@_ = split( "\n", $arg );	# get first line
			$_ = shift( @_ );
			debug( "eval_command.send.arg.1stline: $_", 1 );
			if( /(.+?)-(.+)\.(.+)/ ) {
				if( !db_is_super( $dbh, $mid, $3 )){
					$status = $r{superuser_only};
				}
				elsif( !exists( $opt{$1} )){
					$status = $r{invalid_sendopt};
				}
				elsif(( $2 ne 'ot' ) && !db_is_project( $dbh, $2 )){
					$status = $r{invalid_sendpjn};
				}
			}
		}

		elsif( /give/ ) {	# new maintainer must be pj-member
			$m = db_get_memb_id( $dbh, $arg );
			if( !db_is_member( $dbh, $pid, $m )) {
				$status = $r{new_not_pj_memb};
			}
		}
	}

	# checks, if user has to confirm the command
	if( !is_err( $status ) && is( $cmd, $f{to_confirm} )){
		$status = $r{ok_to_confirm};
	}

	db_set_status( $dbh, $cid, $status );
	return( $status );
}

=head2 validate - validates all command records

C<in-param:	$msg_id - message id
returns:	$status>

=cut

sub validate {
	debug( "##### Start validate: ".localtime, 0 );
	my( $msg_id ) = @_;
	my $status = $r{ok};
	my $dbh = db_connect;	# database handle
	my @rlist = db_select_col( $dbh, 'receive', 'rec_id', "msg_id = '$msg_id'" );
	my @clist = ();
	foreach my $rec_id ( @rlist ) {
		my @t = db_select_col( $dbh, 'command', 'cmd_id', "rec_id = $rec_id" );
		push( @clist, @t );
	}
	my %r;
	foreach my $cmd_id ( @clist ){
		%r = db_select_row( $dbh,
			'receive, command',					# tables
			'proj_id, memb_id, cmdkey, cmdval',			# fields
			"receive.rec_id = command.rec_id and cmd_id = $cmd_id"	# where
		);
#		foreach my $x ( keys %r ){debug( ">>$x: ".$r{$x}, 2 );}
		$status = eval_command( $dbh, $cmd_id, $r{proj_id}, $r{memb_id}, $r{cmdkey}, $r{cmdval} );
	}
	db_disconnect( $dbh );
	return( $status );
}
1;
