<?php
# this script requires previously import of func.inc and menu.inc

#### pnum2par converts (x.x.x) to 00000x000x000x# etc. and appends $new as 0000
function pnum2par( $pnum, $new ){
	if( empty( $pnum ) || $pnum == "()" ) return "";
	if( substr( $pnum, 0, 1 ) == "(" ) $pnum = substr( $pnum, 1 );
	$i = strlen( $pnum ) - 1;
	if( substr( $pnum, $i ) == ")" ) $pnum = substr( $pnum, 0, $i );
	$tok = strtok( $pnum, "." );
	if( $tok ) $res = fill( $tok, 6 );
	while( $tok ){
		$tok = strtok( "." );
		if( $tok ) $res .= fill( $tok, 4 );
	}
	if( $new > 0 ) $res .= fill( $new, 4 );
	return $res."#";
}

#### par2pnum converts 00000x000x000x# to x.x.x etc.
function par2pnum( $ps ){
	if( !strpos( $ps, "#" )) return "";
	$pnum = fmt( substr( $ps, 0, 6 ));
	for( $i = 6, $j = 1; substr( $ps, $i, 1 ) <> "#"; $i += 4 ) {
		$pnum .= ".".fmt( substr( $ps, $i, 4 ));
		$j++;
	}	
	return $pnum;
}

#### strip all tags except <br>, <b>, <i>, <font color='*'>, <a href='*'>
function save_html( $txt ){
	$c1 = chr( 207 );
	$c2 = chr( 208 );
	$txt = str_replace( $c1, '', $txt );
	$txt = str_replace( $c2, '', $txt );
	$txt = eregi_replace( '<br>', $c1."br$c2", $txt );
	$txt = eregi_replace( '<b>', $c1."b$c2", $txt );
	$txt = eregi_replace( '</b>', $c1."/b$c2", $txt );
	$txt = eregi_replace( '<i>', $c1."i$c2", $txt );
	$txt = eregi_replace( '</i>', $c1."/i$c2", $txt );
	$txt = eregi_replace( '<font color=([[:alnum:]|"|\'|#]+)>', $c1."font color=\\1$c2", $txt );
	$txt = eregi_replace( '</font>', $c1."/font$c2", $txt );
	$txt = eregi_replace( '<a href=([^>]+)>([^<]+)</a>', $c1."a href=\\1$c2\\2$c1/a$c2", $txt );
	$txt = strip_tags( $txt );
	$txt = str_replace( $c1, '<', $txt );
	$txt = str_replace( $c2, '>', $txt );
	$txt = ereg_replace( '&xid=[0-9]+','', $txt );
	$txt = ereg_replace( '\?xid=[0-9]+&','?', $txt );
	$txt = ereg_replace( '\?xid=[0-9]+','', $txt );
	return( $txt );
}

#### formats string using simple commands #=<br>, !=<b>, %=<i>, *=red, >=link
function html_format( $txt ){
	$arr = explode( ' ', $txt );
	$r = '';
	while( list( $k, $t ) = each( $arr )){
		if( !empty( $t )) {
			$s1 = substr( $t, 0, 1 );	# first char
			$sn = substr( $t, 1, -1 );	# string except first and last char
			$sl = substr( $t, -1 );		# last char
			if( strstr( '#!%*>', $s1 )){
				if( !strstr( '.,;:!?#', $sl )) $sn .= $sl;
				switch( $s1 ){		# check first char
				case '#':
					if( empty( $sn )){
						$r .= '<br>';
						if( $t == '##' ) $r.= '<br>';
						$sl = '';
					}
					elseif( $sn == '#' ){
						$r .= '<br><br>';
					}
					else {
						$r .= "#$sn";
					}
				break;
				case '!':
					$r .= "<b>$sn</b>";
				break;
				case '%':
					$r .= "<i>$sn</i>";
				break;
				case '*':
					$r .= "<font color='red'>$sn</font>";
				break;
				case '>':
					$p = strpos( $sn, '|' );
					$s1 = $sn;
					if( $p ) {
						$s1 = substr( $sn, 0, $p );
						$s2 = substr( $sn, $p+1 );
					}
					if( $p && !empty( $s2 )) {
						$r .= "<a href='$s1'>$s2</a>";
					} else {
						$r .= "<a href='$s1'>$s1</a>";
					}
				break;
				default:
					$r .= $t;
				}
				if( !empty( $sl ) &&  strstr( '.,;:!?#', $sl )) $r .= $sl;
			}
			else {
				$r .= $t;
			}
			$r .= ' ';
		}
	}
	$r = str_replace( '</b> <b>', ' ', $r );
	$r = str_replace( '</i> <i>', ' ', $r );
	$r = str_replace( "</font> <font color='red'>", ' ', $r );
	return( $r );
}

#### showtext displays the basetext
#### title, maintainer and status are only shown, if show_head is set
function showtext( $proj_id, $vers_id, $show_head ){

	# global vars from menu.inc etc.
	global $prt, $xid, $xidval, $_fontbulk, $_fontinpt, $_fonthdln,
	$_bg5, $_fg3, $_fg4, $_fg5, $_x, $fn, $ln, $em, $hd, $_ini, $_act, $_ver,
	$lang, $ot_maint, $domain, $fqdomain, $chg, $par, $comment, $action, $PHP_SELF;

	$t = getmsg( 22, $xidval, &$lang );

	if( $action == 'ascii' ){

		$qry = "select headln, text from paragraph ";
		$qry .= "where proj_id = $proj_id and vers_id = $vers_id ";
		$qry .= "and length( parastr ) < 8 order by parastr";
		if( !$id = mysql_query( $qry )) errlog( $qry, 21001, 7 );
		while( $row = mysql_fetch_array( $id )) {
			$headln = $row[ "headln" ];
			if( !empty( $headln )) {
				$headln = str_replace( '&', '&amp;', $headln );
				$headln = str_replace( '<', '&lt;', $headln );
				$headln = str_replace( '>', '&gt;', $headln );
				echo "<p>$headln</p>\n\n";
			}
			$text = $row[ "text" ];
			$text = str_replace( '&', '&amp;', $text );
			$text = str_replace( '<', '&lt;', $text );
			$text = str_replace( '>', '&gt;', $text );
			$text = insert_nl( $text, 80, FALSE );
			echo "<p>$text</p>\n";
		}
		exit;
	}

	###################
	# making comments #
	###################

	# was a comment previously made?
	if( !empty( $comment )){
		$comment = str_replace( chr(13).chr(10), " ", $comment );
		$comment = str_replace( chr(10), " ", $comment );
		$comment = stripslashes( $comment );
		$comment = trim( save_html( html_format( $comment )));
	}

	# get user for insert, delete, update comment
	if(( !empty( $par ) && !empty( $comment )) || ( !empty( $chg ) && !empty( $em ))){
		if( !empty( $em )){
			$qry = "select memb_id, last_n, first_n ";
			$qry .= "from member where email = '$em'";
			if( !$id = mysql_query( $qry )) errlog( $qry, 21002, 7 );
			if( $row = mysql_fetch_array( $id )) {	# is member
				$mid = $row[ "memb_id" ];
				$fn = $row[ "first_n" ];
				$ln = $row[ "last_n" ];
			}
			elseif( $action == 'insmemb' ){		# insert new member
				srand((double)microtime()*1000000);
				$wd = rand();
				$c = getmsg( 13, $xidval, &$lang );
				include( 'mins.inc' );
				if( $mid = add_memb( $fn, $ln, $em, $wd, $res )){
					send_mail( $fn, $ln, $em, '', $c[67], $c[60], $c[68] );
					$xid = login_by_form( $em, $wd, '', $xpar, $txt );
				} else {
					$action = 'newmemb';	# try again
				}
				if(( $res == 'new_inserted' ) || ( $res == 'new_exists' )){
					$pj[0] = $proj_id;
					if( chg_proj( $pj, $mid, 'pj_ins', $txt ) &&  !empty( $txt )){
						$res = 'add_proj';
						send_mail( $fn, $ln, $em, $txt, $c[63], $c[60], $c[64] );
					}

				}
			}
			else {					# not member
				$action = 'newmemb';
			}
		}
		elseif( $action == 'insmemb' ){
			$c = getmsg( 13, $xidval, &$lang );
			include( 'mins.inc' );
			$res = 'email_pw_empty';
			$action = 'newmemb';	# try again
		}
		else {			
			$em = "$t[0]@$domain";
		}
		if( empty( $action )){
			if( empty( $fn ) && empty( $ln )){
				$fn = $t[1];
				$ln = $t[2];
			}
			if( empty( $fn )) $fn = "??";
			if( empty( $ln )) $ln = "??";
			if( empty( $mid )) $mid = 0;
		}
	}

	# check if comment is sent again
	if( !empty( $par ) && !empty( $comment ) && empty( $action )){
		$i = 1;
		$pstr1 = pnum2par( $par, $i );		# first possible comment
		$pstr2 = pnum2par( $par, 9999 );	# last possible comment
		$qry = "select max( parastr ) as maxpstr from paragraph ";
		$qry .= "where proj_id = $proj_id and vers_id = $vers_id ";
		$qry .= "and parastr between '$pstr1' and '$pstr2'";
		if( !$id = mysql_query( $qry )) errlog( $qry, 21003, 7 );
		if( !$row = mysql_fetch_array( $id )) {
			$i = 0;
		} else {
			$pstr1 = $row[ 'maxpstr' ];
			$pstr2 = pnum2par( $pstr1, 0 );
			$i = (int) substr( $pstr2, -5, 4 );
		}
		$qry = "select headln, text from paragraph where proj_id = $proj_id ";
		$qry .= "and vers_id = $vers_id and parastr = '$pstr1'";
		if( !$id = mysql_query( $qry )) errlog( $qry, 21004, 7 );
		if( $row = mysql_fetch_array( $id )) {
			if(( $hd == $row[ 'headln' ]) && ( $comment == $row[ 'text' ])){
				$par = ''; $comment = '';
			}
		}
	}
	$comment = addslashes( $comment );

	# user wants to insert a new comment
	if( !empty( $par ) && !empty( $comment ) && empty( $action )){
		$i += 1;

		eval( "\$x = \"$t[3]\";" );
		$txt = "$x:\n\n";
		$txt .= 'http://'.$fqdomain.$PHP_SELF."#$par\n> ($par)\n";

		$parastr = pnum2par( $par, 0 );	# referenced paragraph
		$qry = "select headln, text from paragraph where proj_id = $proj_id ";
		$qry .= "and vers_id = $vers_id and parastr = '$parastr'";
		if( !$id = mysql_query( $qry )) errlog( $qry, 21005, 7 );
		if( !$row = mysql_fetch_array( $id )) errlog( 'no_rows_selected', 21006, 5 );
		$txt .= insert_nl( strip_tags( eregi_replace( "<li>", "- ", $row[ "text" ])), 74, TRUE );

# rm headln from select?
#		$title = strip_tags( $row[ "headln" ]);
#		if( !empty( $title )){
#			if( empty( $hd )){
#				$hd = $title;		# web input first!
#				if( substr( $hd, 0, 3 ) != 'Re:' ) $hd = 'Re: '.$hd;
#			}
#		}
		$hd = trim( strip_tags( $hd ));

		$parastr = pnum2par( $par, $i );	# convert and append
		$send_by = dt_de( date( "Y/m/d H:i" )).", ";
		$send_by .= "<a href=\"mailto:$em\">$fn $ln</a>";

		while( !mysql_query( "insert into paragraph values(
			$proj_id, $vers_id, '$parastr', now(), 
			'$send_by', '$hd', '$comment' )" )){
			if(( mysql_errno() == 1062 ) && ( $i < 10000 )){
				$i++;
				$parastr = pnum2par( $par, $i );
			}
			else {
				errlog( $parstr, 21007, 7 );
			}
		}
		$action = 'commentadd';
		$par = par2pnum( $parastr );		

		$buf = "$t[4]:\nhttp://";
		$buf .= $fqdomain.$PHP_SELF."#$par\n($par)\n";
		$buf .= insert_nl( $comment, 74, FALSE );
		if( !empty( $hd )){
			$par = $hd;
		} else {
			$par = "$t[5] $par";
		}

		# insert into par_mail for later sending: comment
		$txt = addslashes( $txt );
		$qry = "insert into par_mail( proj_id, memb_id, ";
		$qry .= "parastr, subj, text, ctext ) values( $proj_id, ";
		$qry .= "$mid, '$parastr', '$par', '$txt', '$buf' )";
		if( !mysql_query( $qry )) errlog( $qry, 21008, 7 );
		
		$par = '';	# do not open comment form again
	}

	# user wants to update or delete comment
	if( !empty( $chg ) && !empty( $em ) && empty( $action )){	# !empty( $em ) means: correction

		$hd = trim( strip_tags( $hd ));
		$parastr = pnum2par( $chg, 0 );	# referenced paragraph

		# empty comment means delete comment
		if( empty( $comment )){

			$par = substr( $parastr, 0, -1 );	# cut hashmark
			$l = strlen( $par );

			# check whether there ist no subcomment
			$qry = "select parastr ";
			$qry .= "from paragraph where proj_id = $proj_id ";
			$qry .= "and vers_id = $vers_id ";
			$qry .= "and left( parastr, $l ) = '$par' ";
			$qry .= "and length( parastr ) > $l+1";
			if( !$id = mysql_query( $qry )) errlog( $qry, 21009, 7 );
			if( mysql_fetch_row( $id )){
				$par = 'error_subcoms';
			}
			else {
				$qry = "delete from paragraph ";
				$qry .= "where proj_id = $proj_id ";
				$qry .= "and vers_id = $vers_id ";
				$qry .= "and parastr = '$parastr'";
				if( !mysql_query( $qry )) errlog( $qry, 21010, 7 );
				$qry = "delete from par_mail ";
				$qry .= "where proj_id = $proj_id ";
				$qry .= "and memb_id = $mid ";
				$qry .= "and parastr = '$parastr'";
				if( !mysql_query( $qry )) errlog( $qry, 21011, 7 );

				$parastr = substr( $par, 0, -4 );	# cut last num
				$l = strlen( $parastr );

				# select all following comments incl. its subcomments
				$qry = "select parastr from paragraph ";
				$qry .= "where proj_id = $proj_id ";
				$qry .= "and vers_id = $vers_id ";
				$qry .= "and left( parastr, $l ) = '$parastr' ";
				$qry .= "and left( parastr, $l+4 ) > '$par'";
				if( !$id = mysql_query( $qry )) errlog( $qry, 21012, 7 );

				# patch the parastr, pull all nums one step up
				while( $row = mysql_fetch_array( $id )) {
					$par = $row[ "parastr" ];
					$i = substr( $par, $l, 4 ) - 1;	# dec curr num
					$i = fill( $i, 4 );
					$lst = $parastr.$i.substr( $par, $l+4 );
					$qry = "update paragraph ";
					$qry .= "set parastr = '$lst' ";
					$qry .= "where proj_id = $proj_id ";
					$qry .= "and vers_id = $vers_id ";
					$qry .= "and parastr = '$par'";
					if( !mysql_query( $qry )) errlog( $qry, 21013, 7 );
					$qry = "update par_mail ";
					$qry .= "set parastr = '$lst' ";
					$qry .= "where proj_id = $proj_id ";
					$qry .= "and memb_id = $mid ";
					$qry .= "and parastr = '$par'";
					if( !mysql_query( $qry )) errlog( $qry, 21014, 7 );
				}
				$par = '';
				$chg = '';	# do not open correction form again
				$action = 'commentdel';
			}
		}
		else {
			$qry = "update paragraph ";
			$qry .= "set headln = '$hd', text = '$comment' ";
			$qry .= "where proj_id = $proj_id ";
			$qry .= "and vers_id = $vers_id ";
			$qry .= "and parastr = '$parastr'";
			if( !mysql_query( $qry )) errlog( $qry, 21015, 7 );
			$buf = "$t[4]:\nhttp://";
			$buf .= $fqdomain.$PHP_SELF."#$chg\n($chg)\n";
			$buf .= insert_nl( $comment, 74, FALSE );
			$qry = "update par_mail ";
			$qry .= "set subj = '$hd', ctext = '$buf' ";
			$qry .= "where proj_id = $proj_id ";
			$qry .= "and memb_id = $mid ";
			$qry .= "and parastr = '$parastr'";
			if( !mysql_query( $qry )) errlog( $qry, 21016, 7 );
			$chg = '';	# do not open correction form again
		}
	}
	###################
	# generating page #
	###################

	$qry = "select m.last_n, m.first_n, m.email, m.passwd, t.title, ";
	$qry .= "t.titlabb, t.submit, t.status, t.descr, t.keywds, t.invar ";
	$qry .= "from metatext t, member m where t.memb_id = m.memb_id ";
	$qry .= "and t.proj_id = $proj_id and t.vers_id = $vers_id";
	if( !$id = mysql_query( $qry )) errlog( $qry, 21017, 7 );
	if( !$row = mysql_fetch_array( $id )) {
		htmlhead( '?', '' );
		echo "<font $_fonthdln>\n";
		echo "<center><b>$t[42]</b></a></center><br></font>\n";
		echo "<font $_fontbulk>\n<p>\n$t[43]: <a href='mailto:";
		echo "$ot_maint@$domain'>$ot_maint@$domain</a></p></font>";
		foot();
		exit;
	}

	$first_n = $row[ "first_n" ];
	$last_n = $row[ "last_n" ];
	$email = $row[ "email" ];
	$title = $row[ "title" ];
	$titlabb = $row[ "titlabb" ];
	$submit = date_de( $row[ "submit" ] );
	$year = substr( $submit, 6, 4 );
	$status = $row[ "status" ];
	$status = st_lg( $status );
	$iv = htmlentities( $row[ "invar" ]);
	if( $prt ){
		$txt = lnkxid( $PHP_SELF, $xid );
		htmlhead( $title, '' );
		echo "<font $_fonthdln>\n";
		echo "<center><a href='$txt'><b>$title</b></a></center></font>\n";
	} elseif( $show_head ) {
		head( "<a href='index.phtml'>$title</a>", $row[ "keywds" ], $xid, $xpar );
		if( substr( $action, 0, 7 ) == 'comment' ){
			$i = substr( $action, -3 ) == 'add' ? 1 : -1;
			upd_points( $titlabb, $vers_id, $xpar['ppt'], 'comm', $i );
		}
		else {
			upd_points( $titlabb, $vers_id, $xpar['ppt'], 'clic', 1 );
		}
	}
	echo "<font $_fontbulk>\n";

	if( $par == 'error_subcoms' ){
		echo "<font $_fontbulk>\n";
		eval( "\$x = \"$t[6]\";" );
		echo "<p>$x</p>\n";
		echo "<p>$t[7] &nbsp; <a href='".lnkxid( "$PHP_SELF?chg=$chg", $xid );
		echo "#$chg'><b>... $t[8]</b></a> &nbsp; ";
		# prt=0 is a workaround due to caching effects (could be any flag...)
		echo "<a href='".lnkxid( "$PHP_SELF?prt=0", $xid );
		echo "#$chg'><b>... $t[9]</b></a></p></font>\n";
		foot();
		exit;
	}

	$logout = empty( $xid );
	if( $show_head && ( $status == $_act ) && !$logout && !$prt ){
		if( empty( $fn ) || empty( $ln )){
			$qry = "select last_n, first_n, email from member ";
			$qry .= "where memb_id = ".$xpar[ 'mid' ];
			if( !$id = mysql_query( $qry )) errlog( $qry, 21018, 7 );
			if( !$row = mysql_fetch_array( $id )) errlog( 'no rows selected', 21019, 5 );
			$fn = $row[ 'first_n' ];
			$ln = $row[ 'last_n' ];
			$em = $row[ 'email' ];
		}
	}
	if( $show_head ){ 
		echo "<table width='100%' cellspacing='4'>\n<tr>\n<td>\n";
		echo "<font $_fontbulk>\n<font size='+1'><b>$t[10]: ";
		$x = "$first_n $last_n";
		if( !$logout ) $x = "<a href='mailto:$email'>$x</a>";
		echo "$x, $_ver $vers_id, $submit</b>";
		echo "</font></font></td>\n";
		if(( $status == $_act ) && !$logout && !$prt ){
			echo "<td rowspan='2' align='right'>\n<font $_fontbulk>\n";
			eval( "\$x = \"$t[12]\";" );
			echo "<a href='";
			echo lnkxid( "/comments.phtml?pid=$proj_id", $xid );
			echo "'><b>$x</b></a></font></td>";
		} elseif(( $status == $_act ) && !$prt ) {
			echo "<td rowspan='2' align='right'>\n<font $_fontbulk>\n";
			echo add_xid( $t[13], $xid )."</font></td>";
		}
		echo "</tr>\n<tr>\n<td>\n<font $_fontbulk>\n<font size='+1'>\n";
		if( $prt ){
			echo "<b>$t[14]: ".date( 'd.m.Y, H:i' );
			echo "</b></font></font></td></tr>\n";
			echo "<tr>\n<td>\n<font $_fontbulk>\n<font size='+1'>\n";
			echo "<b>$t[15]: http://$fqdomain$PHP_SELF</b>";
		} else {
			echo "<b>$t[16]: $status &nbsp; <img src='/images/more.png' ";
			echo "border='0' height='12' width='12' alt=''>&nbsp;<a href='";
			$txt = "$PHP_SELF?prt=1";
			if( !empty( $action )) $txt .= "&action=$action";
			echo lnkxid( $txt, $xid );
			echo "'>$t[17]</a></b>";
		}
		echo "</font></font></td></tr></table>\n";
	}

	$qry = "select parastr, send_by, headln, text, submit from paragraph ";
	$qry .= "where proj_id = $proj_id and vers_id = $vers_id ";
	if( substr( $action, 0, 4 ) == 'hide' ){
		$h = 1;
		if( $action != 'hideall' ) $h = (int)substr( $action, 4 );
		$j = (( $h - 1 ) * 4 ) + 8;
		$qry .= "and length( parastr ) < $j ";
	}
	# active text paragraph was clicked for comment
	if(( $status == $_act ) && ( !empty( $par ) || !empty( $chg ))){
		if( !empty( $par )){
			$h = pnum2par( $par, 0 );
		} else {
			$h = pnum2par( $chg, 0 );
		}
		$qry .= "and parastr = '$h'";
		echo "<p>(...)</p>\n";
	}
	$qry .= "order by parastr";
	if( !$id = mysql_query( $qry )) errlog( $qry, 21020, 7 );
	while( $row = mysql_fetch_array( $id )) {
		$ps = $row[ "parastr" ];
		$send_by = $row[ "send_by" ];
		if( $logout ) $send_by = strip_tags( $send_by );
		$headln = $row[ "headln" ];
		$text = $row[ 'text' ];
		$istxt = $text != '.';		# paragraph is empty

		# check submit time
		$txt = substr( $row[ "submit" ], 0, 10 );
		# check today
		$tdiff = $txt == date( 'Y-m-d' );

		# check today 0 am to 6 am
		if( date( 'G' ) < $_stime ){
			if( $tdiff ){			# comment from today before 6?
				$tdiff = substr( $row[ "submit" ], 11, 2 ) < $_stime;
			}
			# comment from yesterday after 6?
			elseif( $txt == date( 'Y-m-d',
				mktime(0,0,0,date('m'),date('d')-1,date('Y')))){
				$tdiff = substr( $row[ "submit" ], 11, 2 ) >= $_stime;
			}
		}

		for( $i = 6, $j = 1; substr( $ps, $i, 1 ) <> "#"; $i += 4 ) {
			echo "<ul>";
			$j++;
		}	

		if( empty( $action )) $hd = strip_tags( stripslashes( $headln ));
		if(( $j == 1 ) && !empty( $headln )){
			echo "<h4>$headln</h4>\n";
			$headln = '';
		}
		if( $istxt ) echo "<p>\n";

		$pnum = par2pnum( $ps );

		# mark text to be corrected red
		if( $chg == $pnum ) echo "<font color='$_fg3'>\n";

		if( $istxt ) echo "<a name='$pnum'></a>\n";
		if( $istxt && $show_head && !$prt ){
			if(( substr( $action, 0, 4 ) == 'hide' ) && ( $j == $h )){
				echo "<a href='".lnkxid( $PHP_SELF, $xid )."'>";
				echo "<img src='/images/blueplus.png' border='0' ";
				echo "height='12' width='12' alt='[$t[18]]' ";
				echo "title='[$t[18]]'></a>\n";
			} else {
				if( $j == 1 ){
					$txt = "[$t[19]]";
					echo "<a href='";
					echo lnkxid( "$PHP_SELF?action=hideall", $xid )."'>";
				} else {
					eval( "\$x = \"$t[20]\";" );
					$txt = "[$x]";
					echo "<a href='";
					echo lnkxid( "$PHP_SELF?action=hide$j", $xid )."'>";
				}
				echo "<img src='/images/blueminus.png' border='0' ";
				echo "height='12' width='12' alt='$txt' ";
				echo "title='$txt'></a>\n";
			}
		}

	 	if( $istxt ) echo "<b>($pnum) $headln</b>";
		if( !empty( $headln )) echo ', ';

		if( $j > 1 ) echo $send_by.': ';
		if( $istxt ) echo add_xid( $text, $xid );

		# end of red text mark
		if( $chg == $pnum ) echo "</font>";

		# show comment click link for active text
		if(( $status == $_act ) && ( $par != $pnum ) && ( $chg != $pnum  )
			&& $istxt && !$prt ){

			$n = 0; $i = 0;
 			while( $i = strpos( strtolower($text), "</ul>", ++$i )) $n = $i;
			$i = strlen( $text ) - 7;
			if(( $i < 8 ) || ( $n < $i )) echo "<br>";

			# comments via http-link
			echo "<a href='".lnkxid( "$PHP_SELF?par=$pnum", $xid );
			echo "#$pnum' style='color:$_fg5'><img src='/images/arr.png' ";
			echo "border='0' alt='$t[21]' title='$t[21]'>";
			echo "<b>$t[22]</b></a>";

			# member can change the comment for 12 hours
			if( $show_head && !$logout && eregi( $xpar[ 'xem' ], $send_by ) && $tdiff ){
				echo " <b>&amp; <a href='";
				echo lnkxid( "$PHP_SELF?chg=$pnum", $xid );
				echo "#$pnum'>$t[23]</a></b>";
			}
		}

		for( $i = 1; $i < $j; $i++) echo "</ul>";
		if( $istxt ) echo "</p>\n";

		# active text paragraph was clicked for comment
		if(( $status == $_act ) && (( $par == $pnum ) || ( $chg == $pnum ))){
			
			$l = lnkxid( $PHP_SELF, $xid );
			$txt = '';
			$hd = ereg_replace( "\"", "&quot;", $hd );
			if( empty( $action ) && ( $par == $pnum )){
				if( !empty( $hd ) && ( substr( $hd, 0, 3 ) != 'Re:' )) $hd = 'Re: '.$hd;
			}
			elseif( empty( $action )) {
				$txt = $text;
			}
			elseif(( $action == 'newmemb' ) || ( $action == 'insmemb' )) {
				$txt = htmlentities( $comment );
			}

			echo "<table cellpadding='2'>\n";
			echo "<form action='$l#$pnum' method='post'>\n";
			echo "<tr>\n<td>\n<font $_fontbulk>\n$t[24]:</font></td>\n";

			# not logged in: first/last name and email
			if(( $par == $pnum ) && ( $logout )
			&& ( $action != 'newmemb' ) && ( $action != 'insmemb' )){
				echo "<td><font $_fontinpt>\n";
				echo "<input type='text' name='fn' value='$fn' size='24'>\n";
				echo "<input type='text' name='ln' value='$ln' size='35'>\n";
				echo "</font></td></tr>\n<tr>\n<td>\n";
				echo "<font $_fontbulk>\n$t[25]:</font>";
				echo "</td>\n<td>\n<font $_fontinpt>\n";
				echo "<input type='text' name='em' value='$em' size='61'>\n";
			}
			else {	# logged in or potentially new member
				echo "<td bgcolor='white'>\n<font $_fontbulk>\n";
				echo "&nbsp;$fn $ln</font></td></tr>\n<tr>\n<td>\n";
				echo "<font $_fontbulk>\n$t[25]:</font>";
				echo "</td>\n<td bgcolor='white'>";
				echo "<font $_fontbulk>\n&nbsp;$em\n";
				echo "<input type='hidden' name='em' value='$em'>\n";
			}
			echo "</font></td></tr>\n<tr>\n<td>\n";
			echo "<font $_fontbulk>\n$t[26]:</font></td>\n";

			# headline = subject
			if( $action == 'newmemb' ){
				echo "<td bgcolor='white'>\n<font $_fontbulk>\n";
				echo "&nbsp;$hd";
			}
			else {
				echo "<td>\n<font $_fontinpt>\n";
				echo "<input type='text' name='hd' value='$hd' size='61'>\n";
			}
			echo "</font></td></tr>\n<tr>\n<td valign='top'>\n";
			echo "<font $_fontbulk ";
			if( $par == $pnum ){
				echo "color='$_fg5'>\n";
				echo "<input type='hidden' name='par' value='$pnum'>\n";
				echo "<b>$t[27]";
			}
			else{
				echo "color='$_fg3'>\n";
				echo "<input type='hidden' name='chg' value='$pnum'>\n";
				echo "<b>$t[28]";
			}
			echo " $t[29]<br>$pnum:<br><br><br><br><br>";
			echo "<a href='$l#$par'>$t[30]</a></b></font></td>\n";

			# comment
			if( $action == 'newmemb' ){
				echo "<td bgcolor='white' valign='top'>\n";
				echo "<font $_fontbulk>\n&nbsp;$txt";
			}
			else {
				echo "<td>\n<font $_fontinpt>\n";
				echo "<textarea name='comment' rows='8' cols='61' ";
				echo "wrap='virtual'>$txt</textarea>";
			}
			echo "</font></td></tr>\n";
			echo "<tr>\n<td colspan='2' align='center'>\n<font $_fontbulk>\n";
			echo "<input type='submit' value='$t[31]'>\n";	# save
			echo "</font></td></tr></form>\n";

			# delete comment or become member
			if(( $chg == $pnum ) || ( $action == 'newmemb' )){
				if( $chg == $pnum ){
					$pstr1 = pnum2par( $pnum, 0 );
					$pstr1 = substr( $pstr1, 0, strlen( $pstr1 )-5 ).'#';
					$pstr2 = par2pnum( $pstr1 );
					$text = $t[32];		# delete
				}
				else {
					$pstr2 = $pnum;
					$text = $t[31];		# save
				}
				echo "<form action='$l#$pstr2' method='post'>\n";
				if( $chg == $pnum ){
					echo "<input type='hidden' name='chg' value='$pnum'>\n";
					echo "<input type='hidden' name='em' value='$em'>\n";
				}
				else {	# newmemb
					echo "<tr>\n<td colspan='2' bgcolor='$_bg5'>\n";
					echo "<font $_fontbulk>\n$t[36]\n";
					echo "</font></td></tr>\n";
					echo "<tr>\n<td>\n<font $_fontbulk>\n$t[24]";
					echo "</font></td>\n";
					echo "<td><font $_fontinpt>\n";
					echo "<input type='text' name='fn' value='$fn' size='24'>\n";
					echo "<input type='text' name='ln' value='$ln' size='35'>\n";
					echo "</font></td></tr>\n<tr>\n<td>\n";
					echo "<font $_fontbulk>\n$t[25]:</font>";
					echo "</td>\n<td><font $_fontinpt>\n";
					echo "<input type='text' name='em' value='$em' size='61'>\n";
					echo "<input type='hidden' name='hd' value='$hd'>\n";
					echo "<input type='hidden' name='par' value='$pnum'>\n";
					echo "<input type='hidden' name='comment' value='$txt'>\n";
					echo "<input type='hidden' name='action' value='insmemb'>\n";
					echo "</font></td></tr>\n";
				}
				echo "<tr>\n<td colspan='2' align='center'>\n<font $_fontbulk>\n";
				echo "<input type='submit' value='$text'>\n";
				echo "</font></td></tr></form>\n";
			}

			# result of becoming a new member
			if(( $action == 'newmemb' ) || ( $action == 'insmemb' )){
				if( !empty( $res )){
					$txt = "&raquo;$titlabb&laquo;";
					$txt = get_res( $res, $c, $fn, $ln, $em, 'x', $txt );
					echo "<tr>\n<td colspan='2' bgcolor='$_bg5'>\n<font $_fontbulk>\n";
					echo "$txt</font></td></tr>\n";
				}
			}

			# formatting hints
			if( $action != 'newmemb' ){
				$f1 = "<font color='$_fg4'>\n"; $f2 = '</font>';
				echo "<tr>\n<td valign='top'>\n<font $_fontbulk>\n";
				echo "$t[33]:";
				for( $i = 3; $i <= $t[40]; $i++ ) echo '<br>';
				echo "$t[37]</font></td>\n";
				echo "<td bgcolor='$_bg5'>\n<font $_fontbulk>\n";
				for( $i = 1; $i <= $t[40]; $i++ ) {
					$txt = $t[ 40 + $i ];
					eval( "\$x = \"$txt\";" );
					$x = add_xid( $x, $xid );
					echo "&nbsp;$x<br>\n";
				}
			}
			echo "</table>\n<p>(...)</p>\n";
		}

	}
	echo "</font>\n";
	if( $prt ){
		echo "<hr size='1' noshade width='100%'>\n";
		echo "<font $_fontbulk>\n";
		echo "<p>\n$t[34] (c) $year $first_n $last_n</p>\n";
		$invar = explode( substr( $iv, 0, 1 ), substr( $iv, 1 ));
		eval( "\$x = \"$_x[18]\";" );
		echo add_xid( $x, $xid );
		echo "</font>\n<br>";
	}
}
?>
